; Copyright 1999 by Henter-Joyce, Inc.
;03/30/99by j.c

include "wab32.jsh"
include "wab32.jsm"
include "hjconst.jsh"
include "hjglobal.jsh"

Void Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, buttonLabel, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msgLabelNotFound, ot_control_name)
EndIf
EndFunction

Int Function FindString (handle hwnd, string str, int direction, int restriction)
; overrides the built-in FindString to handle searching for labels in the toolbar.
var
	int c,
	int x,
	int y
if ((GetControlId (hwnd) == tool_bar) &&
	(GetWindowSubTypeCode (hwnd) == wt_toolbar) && restriction) then
; the search is restricted to the Outlook 98 toolbar, so search on your own!
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	RestrictCursor (off)
	while ((GetCurrentWindow () == hwnd) &&
		(c<20))
		if (GetWord () == str) then
			let x = GetCursorCol ()
			let y = GetCursorRow ()
			RestoreCursor ()
			JawsCursor ()
			MoveTo (x,y)
			return 1
		EndIf
		NextWord ()
		let c = c+1
	EndWhile
	return 0
else
	return FindString (hwnd, str, direction, restriction)
EndIf
EndFunction

HANDLE Function GetToolbar ()
var
	handle WinHandle
let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar)
if (winHandle && 
	GetWindowClass (winHandle) == wc_toolbar) then
	return winHandle
EndIf
return 0
EndFunction

Void Function ToolBar ()
var
	handle winHandle,
	int item
let winHandle = GetToolbar ()
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msgToolBarNotFound, ot_message)
	return
EndIf
let item = dlgSelectItemInList (strToolbar	, ToolbarDialogName, true)
let nSuppressEcho = true
delay (2)
if (item == NewContact) then
If FindString (Getfocus (), ContactButton, s_top, s_unrestricted) then
LeftMouseButton ()
PcCursor ()
EndIf
elif (item == NewGroup) then
If FindString (getfocus (), GroupButton, s_top, s_unrestricted) then
LeftMouseButton ()
PcCursor ()
EndIf
ElIf (Item == Properties) then
If FindString (GetFocus (), PropertiesButton, s_top, s_unrestricted) then
LeftMouseButton ()
PcCursor ()
EndIf
elIf (Item == Delete) then
If FindString (GetFocus (), DeleteButton, s_top, s_unrestricted) then
LeftMouseButton ()
PcCursor ()
EndIf
ElIf (Item == Find) then
If findString (GetFocus (), FindButton, s_top, s_unrestricted) then
LeftMouseButton ()
PcCursor ()
endIf
elIf (Item == Print) then
If FindString (GetFocus (), PrintButton, s_top, s_unrestricted) then
LeftMouseButton ()
PcCursor ()
endIf
ElIf (Item == Send) then
if FindString (GetFocus (), 
SendButton , s_top, s_unrestricted) then
LeftMouseButton ()
PcCursor ()
EndIf
EndIf
let nSuppressEcho = false
EndFunction
Int Function IsToolbarList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
	if (GetWindowName (GetRealWindow (hwnd)) == ToolbarDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Script CallToolBar ()
ToolBar ()
EndScript

Script WindowKeysHelp ()
Say(msg54, ot_help) ;Use Shift + F1 to display the screen tips for Outlook 98
Say(msg55, ot_help) ;Use Control + Shift + D to Dial from Outlook 98
Say(msg56, ot_help) ;Use Control + shift + F to perform an advanced find
Say(msg57, ot_help) ;Use Control + shift + > to move to the next item
Say(msg58, ot_help) ;Use Control + shift + < to move to the previous item
Say(msg59, ot_help) ;Use Control + Q to mark an item as read
Say(msg60, ot_help) ;Use Control + r to reply to a message
Say(msg61, ot_help) ;Use Control + Shift + R to reply to all in a message
Say(msg62, ot_help) ;Use Control + F to forward a message
Say(msg63, ot_help) ;Use Shift + F3 to switch between upper and lower case
Say(msg64, ot_help) ;Use Control + Shift + Z to clear formatting
Say(msg65, ot_help) ;Use Control + Shift + A to create an appointment
Say(msg66, ot_help) ;Use Control + shift + C to create a contact
Say(msg67, ot_help) ;Use Control + Shift + E to create a new folder
Say(msg68, ot_help) ;Use Control + Shift + J to create a journal entry
Say(msg69, ot_help) ;Use Control + Shift + M to create a message
Say(msg70, ot_help) ;Use Control + Shift + N to create a note
Say(msg71, ot_help) ;Use Control + Shift + Q to create a meeting request
Say(msg72, ot_help) ;Use Control + Shift + P to find people
Say(msg73, ot_help) ;Use Control + Shift + K to create a task
Say(msg74, ot_help) ;Use Control + shift + U to create a task request
Say(msg75, ot_help) ;Use Control + Chift + H to create a new office document
Say(msg76, ot_help) ;Use F5 to receive Email messages
Say(msg77, ot_help) ;Use Control + shift + G to flag item for follow up
Say(msg78, ot_help) ;Use alt + S to save and close an item
Say(msg79, ot_help) ;Use Control + Y to go to a specific folder
Say(msg80, ot_help);Use Control + Shift + S to post item to a specific folder
Say(msg81, ot_help) ;Use Control + shift + Y to copy an item
Say(msg82, ot_help) ;Use Control + Shift + V to move an item to a specific folder
Say(msg83, ot_help) ;Use Control + Shift + B to open the address book
Say(msg84, ot_help) ;Use shift + F10 to display short cuts for Outlook 98
Say(msg85, ot_help);Use F4 to search for text
Say(msg86, ot_help) ;Use Shift + F4 to search for the next occurrance of text
Say(msg87, ot_help) ;Use Control + shift + I to move to the In Box from anywhere
EndScript

Script ScriptfileName ()
ScriptAndAppNames (msgOutlookAddressBook)
EndScript
